Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission0_1.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.5,
		BPGainMultiplier 	= 1.5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		DefaultHiveTowerCount = 7,	
		
        KillReward_Mobile   = 1,
        KillReward_Tower    = 100,
        KillReward_Hive     = 2000,
	},
	Rules = 
	{
		AutoCapture 	= true,		--Destroying hives automatically counts as a capture
		NoPushback		= true,		--Can the player's points be captured?	
		NoTowerRespawn  = true,     --Can the hive towers respawn?
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 1,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
			[[ZU_NONE]],
			[[ZU_NONE]],
			[[ZU_NONE]],		
			[[ZU_NONE]],
			[[ZU_HIVE_SPIKES]],			
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		    [[MU_CHOPPER]],
		},	
		Locked =
		{
		},			
	},
	
	GetLevelReward = function ()
		return GameWorld:GetStat([[ST_XENOCIDE_REWARD]])
	end
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		LevelUtils.CreateXenocideTimer(100000, 40000, 	function ()
															GameWorld:GameOver(true)		
															CaptureAllBonus:Disable()
														end)
		LevelUtils.CreateXenocideRewardCounter()
		CaptureAllBonus:Enable()
		
		ScriptMgr:DoDelayedCall(1000, function () GameWorld:MakeAnnouncement("Evacuation\nIn 2 Minutes"); end)
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Dialogue Triggers
DialogueScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        self.capture_counter = self.capture_counter + 1
        
        local texthdl = nil
        if self.capture_counter == 5 then
            texthdl = GameWorld:ShowText("We dream new toxins\nSynapses grow stronger\nObserve together", "Alien")  
        end
        
        if texthdl then
            ScriptMgr:DoDelayedCall(15000, function () texthdl:ClearText(); end)
        end
      
	end)
DialogueScript:Enable()

------------------------------------------------------------------------------- Tracked objective for killing everything
local bonusSize = 4000
CaptureAllBonus = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("bonusobj", "Kill all hives for a $" .. bonusSize .. " bonus")
		
		local text_hdl = GameWorld:ShowText("We're short on time squad!\nKill all you can before the clock runs out.\nBonus pay for wiping the area clean, you hear?", "Sarge")
		ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("bonusobj", [[complete]])
	
		GameWorld:MakeAnnouncement("$" .. bonusSize .. "\nBonus Earned")
		GameWorld:ChangeStat("ST_XENOCIDE_REWARD", bonusSize)
	
		GameWorld:ClearText()
		GameWorld:GameOver(true)
	
		SteamAchievements:SetAchievement("BEAT_SUDDEN_STRIKE_EXTRA")
	
		self:Disable()
	end)
